/*
 * @(#)AttributedElementEvent.java  1.0  2006-03-20
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */


package ch.hslu.cm.simulation;

import ch.hslu.cm.cer.model.CEREntitySet;

import ch.hslu.cm.cer.model.CERRelationshipSet;

import java.util.*;
/**
 * AttributedElementEvent.
 *
 * @author  Werner Randelshofer
 * @version 1.0 2006-03-20 Created.
 */
public class AttributedElementEvent extends EventObject {
    private int index;
    private SimulatedAttribute attribute;
    
    public AttributedElementEvent(SimulatedObject source) {
        super(source);
    }
    public AttributedElementEvent(SimulatedObject source, int index, SimulatedAttribute attribute) {
        super(source);
        this.index = index;
        this.attribute = attribute;
    }
    
    public CEREntitySet getEntitySet() {
        return (CEREntitySet) getSource();
    }
    public CERRelationshipSet getRelationshipSet() {
        return (CERRelationshipSet) getSource();
    }

    public int getIndex() {
        return index;
    }

    public SimulatedAttribute getAttribute() {
        return attribute;
    }
}
